#include <bits/stdc++.h>
#define ll long long

using namespace std;

const int mxN = 3*1e5;
int n;
bool visited[mxN+10];
vector<pair<int, char> > adj[mxN+10];

int Check(int u, int s, char l){

    int r = 0;
    for (int i = 0; i < adj[u].size(); i++){
        if (adj[u][i].first == s) continue;
        if (adj[u][i].second != l) r++;
    }
    return r;
}

void SolveForOneS(int a, int b){

    int ans = 0;

    for (int i = 0; i < adj[a].size(); i++){
        if (adj[a][i].first == b) continue;
        int u = adj[a][i].first;
        int l = adj[a][i].second;
        ans += Check(u, a, l);
    }

    for (int i = 0; i < adj[b].size(); i++){
        if (adj[b][i].first == a) continue;
        int u = adj[b][i].first;
        int l = adj[b][i].second;
        ans += Check(u, b, l);
    }

    array<char, 4> letters;
    letters[0] = letters[1] = letters[2] = letters[3] = 0;
    for (int i = 0; i < adj[b].size(); i++){
        if (adj[b][i].first == a) continue;
        char l = adj[b][i].second;
        if (l == 'I') letters[0]++;
        else letters[1]++;
    }

    for (int i = 0; i < adj[a].size(); i++){
        if (adj[a][i].first == b) continue;
        char l = adj[a][i].second;
        if (l == 'I') letters[2]++;
        else letters[3]++;
    }
    ans += letters[0] * letters[3] + letters[1] * letters[2];

    cout << ans << endl;
}

void SolveForLinear(){

    map<tuple<int, int, int>, vector<int> > pre;
    tuple<int, int, int> t = make_tuple(0, 0, 0);
    if (adj[1][0].second == 'S') get<0>(t)++;
    if (adj[1][0].second == 'I') get<1>(t)++;
    if (adj[1][0].second == 'O') get<2>(t)++;
    pre[t].push_back(2);
    int s = 2;
    while (s != n){
        int l = adj[s][1].second;
        if (adj[s][1].second == 'S') get<0>(t)++;
        if (adj[s][1].second == 'I') get<1>(t)++;
        if (adj[s][1].second == 'O') get<2>(t)++;

        int j = min(get<0>(t), min(get<1>(t), get<2>(t)));
        if (j) { get<0>(t)-=j; get<1>(t)-=j; get<2>(t)-=j; }

        pre[t].push_back(s+1);
        s++;
    }
    ll ans = 0;
    map<tuple<int, int, int>, vector<int> >::iterator itr = pre.begin();
    for (; itr != pre.end(); ++itr){
        int m = itr->second.size();
        if (itr->first == make_tuple(0, 0, 0))
            ans += m;
        ans += (ll)(((ll)m * (ll)(m - 1)) / 2);
    }
    cout << ans << endl;
}

int dfs(int s, int l, tuple<int, int, int> state, ll ans){

    visited[s] = true;
    if (l == 'S') get<0>(state)++;
    if (l == 'I') get<1>(state)++;
    if (l == 'O') get<2>(state)++;

    if (get<0>(state) == get<1>(state) && get<1>(state) == get<2>(state))
        ans++;


    for (int i = 0; i < adj[s].size(); i++){
        if (visited[adj[s][i].first]) continue;
        ans = dfs(adj[s][i].first, adj[s][i].second, state, ans);
    }

    if (l == 'S') get<0>(state)--;
    if (l == 'I') get<1>(state)--;
    if (l == 'O') get<2>(state)--;
    visited[s] = false;

    return ans;
}

int main(){

    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    cin >> n;
    int nS = 0, nI = 0, nO = 0;
    int sPi, sPj;
    bool isLinear = true;
    for (int i = 0; i < n - 1; i++){
        int a, b;
        char s;
        cin >> a >> b >> s;
        if (s == 'S') { nS++; sPi = a; sPj = b; }
        if (s == 'I') nI++;
        if (s == 'O') nO++;
        if (abs(a - b) != 1) isLinear = false;
        adj[a].push_back(make_pair(b, s));
        adj[b].push_back(make_pair(a, s));
    }
    if (!nS || !nI || !nO){
        cout << "0" << endl;
        return 0;
    }
    if (nS == 1){
        SolveForOneS(sPi, sPj);
        return 0;
    }
    if (isLinear){
        SolveForLinear();
        return 0;
    }
    if (n <= 5000){
        ll ans = 0;

        for (int i = 1; i <= n; i++)
            ans += dfs(i, '?', make_tuple(0, 0, 0), 0) - 1;

        cout << ans / 2 << endl;
        return 0;
    }
    cout << "1" << endl;

    return 0;
}